<?php 
/**
 * Display Blog Category
 *
 * @package Valio Theme
 * @subpackage Valio Theme
 * @since Valio Theme 1.0
 */
?>

<?php
get_header();
?>

	<div class="category-page">
		<section class="category-title">
			<span class="ct-phrase">Le blog</span>
			<?php the_archive_title( '<h1 class="ct-title">', '</h1>' );?>
			<span class="ct-subtitle">Certe, inquam, pertinax non emolumento aliquo</span>
			<div class="ct-separator"></div>
		</section>

		<section class="articles-wrapper">
			<?php if ( have_posts() ) : ?>

				<?php
				while ( have_posts() ) :
					the_post();?>

					<a href="<?php the_permalink(); ?>"><article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<div class="aa-image">
							<?php if ( has_post_thumbnail() ) { ?>
								<img src="<?php the_post_thumbnail_url() ?>">
							<?php } else { ?>
								<img src="<?php bloginfo('template_directory'); ?>/images/default.jpg">
							<?php } ?>
						</div>


						<div class="aa-content">
							<?php the_title( sprintf( '<h2 class="entry-title">'), '</h2>' ); ?>
							<p>
								<?php the_excerpt(); ?>
							</p>
						</div>
					</article></a>

				<?php endwhile;

			endif;?>
		</section>
	</div>
<?php
get_footer();
?>